
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Jul 23 07:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version KMNG_ATP_TST_main.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/************* Include Files **************************************/
#include "DX_VOS_Stdio.h"
#include "DX_VOS_Utils.h"
#include "DX_VOS_File.h"
#include "MW_ATP_UTIL_funcs.h"
#include "MNG_ATP_TST_Defines.h"
#include "MNG_ATP_TST.h"
#include "MNG_TST_Utils.h"
#include "DX_VOS_Mem.h"
#ifdef DX_SUPPORT_SPEC_LCS
	#include "MNG_ATP_TST_Specific_LCS.h"
#endif


/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
#if MNG_TST_LOG_ENABLE 
DxVosFile  TST_MNG_main_log;
char      *TST_MNG_main_log_fname = DX_NULL;
#endif

/*************** Private function prototype ************************/
/************************ Public Functions *************************/


 DxStatus MNG_ATP_menu ( void )

 {
    /********* TST Variables Definitions ************/
    DxUint32_t          TST_index = 0;
    DxChar              TST_Var;
    DxError_t           TST_Error = DX_SUCCESS, TST_Result = DX_SUCCESS;
    DxBool_t            TST_Endflag = DX_FALSE;    
    
    DxChar* TST_TestsNameStrings[] = 
    {      
      "RKEK test - set and use RKEK",
      "OEM test - set and use OEM pub key",
      "SJTAG test - set and use SJTAG pub key",
      "Monotonic counter test",
      "Life cycle secure test",
      "Life cycle security disabled test",
      "Random vector test",
      "Warm Boot Indication test",
      "Life cycle specific test",
      "Display pacakage versions"
      
    };
    
#if _DEBUG
    DX_VOS_DbgPrint_SetPrintFunc(DX_VOS_DebugFilePrint);
#endif

#if MNG_TST_LOG_ENABLE
    TST_MNG_main_log = DX_NULL; 
    
    TST_MNG_main_log_fname = argv[2];
    TST_Error = DX_VOS_FOpen(&TST_MNG_main_log, TST_MNG_main_log_fname ,"w+");
    if (TST_Error != DX_SUCCESS)
    {
      DX_VOS_Printf("CANT OPEN LOG FILE \n");      
      return MNG_TEST_FAIL;
    }
#endif
   
  /* Only relevant in debug mode */
  #ifdef DX_TST_DEBUG_OTP
    DX_VOS_MemSetZero((void*)DX_TST_DBG_OTP_ADDR, DX_TST_DBG_OTP_SIZE);
  #endif
  
    while(1)
    {
      /******** Main Menu - User chooses how to run the tests ********/
      MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n-------------- DISCRETIX LTD 2007  ------------\n"));     
      MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n Please enter test number :\n"));
      for (TST_index = 0; TST_index < TST_MAX_NUM_OF_MNG_ATP_TESTS; TST_index ++)
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"[%d] - Run %s\n",TST_index,TST_TestsNameStrings[TST_index]));
      }
      MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"[Z] - End of Management Tests \n"));
      MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n------------------------------------------------\n"));
    
      GET_NON_WHITE_SPACE_CHAR(TST_Var);
      
      switch(TST_Var)
      {        
        case '0':
          #ifndef DX_OTP_BURN_NOT_SUPPORTED
          TST_Error = MNG_ATP_TST_Set_And_Use_RKEK();            
          #else
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
          #endif
          break;
        case '1':
          #ifndef DX_OTP_BURN_NOT_SUPPORTED
          TST_Error = MNG_ATP_TST_Set_And_Use_OEM_PubKey();
          #else
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
          #endif
          break;
        case '2':
          #ifndef DX_OTP_BURN_NOT_SUPPORTED
          TST_Error = MNG_ATP_TST_Set_And_Use_SJTAG_PubKey();
          #else
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
          #endif
          break;
        case '3':
          TST_Error = MNG_ATP_TST_Monotonic_Counter();
          break;
      	case '4':
      	  #ifndef DX_OTP_BURN_NOT_SUPPORTED
      	  TST_Error = MNG_ATP_TST_Set_LCS_To_Secure_State();   
      	  #else
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
          #endif   	  
      	  break;
      	case '5':
      	  #ifndef DX_OTP_BURN_NOT_SUPPORTED
      	  TST_Error = MNG_ATP_TST_Set_LCS_To_Security_Disable();
      	  #else
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
          #endif  
      	  break;
      	case '6':
      	  TST_Error = MNG_ATP_TST_Random_Vector_Test();
      	  break;
      	case '7':
      	  TST_Error = MNG_ATP_WarmBootIndication_Test();
      	  break;      	  
        case '8':
      	  #ifdef DX_SUPPORT_SPEC_LCS
      	    #ifndef DX_OTP_BURN_NOT_SUPPORTED 
      	  	TST_Error = MNG_ATP_TST_Set_LCS_To_Spec_Secure_State();
      	  	#else
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
            #endif
      	  #else
      	  	MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Operation Not Supported !!! \n"));
      	  #endif
      	  break;      	  
        case '9':
      	  TST_Error = MNG_ATP_TST_Display_Versions();
      	  break;      	  
        case 'Z':
          DX_VOS_Printf("\n End of MNG tests \n");
          TST_Endflag = DX_TRUE;
          break ;
        default:
          MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"User choice is illegal !!\n"));        
      }
      if (TST_Endflag == DX_TRUE)
        break;
    
      TST_Result = DX_VOS_StrToInt(&TST_Var, (DxInt32_t*)&TST_index, 10);
      if (TST_Result != DX_SUCCESS)
		MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"DX_VOS_StrToInt failed!!!\n"));      	
      
      if (TST_Error == DX_SUCCESS)
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***********************************************************\n"));
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"%s PASSED SUCCESSFULLY\n",TST_TestsNameStrings[TST_index]));
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***********************************************************\n"));
      }
      else
      {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***********************************************************\n"));
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"%s FAILED\n",TST_TestsNameStrings[TST_index]));
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"***********************************************************\n"));
      }
    }
    
    
    #if MNG_TST_LOG_ENABLE
    DX_VOS_FClose(TST_main_log);
    #endif
    return TST_Error;
 }/* End of MNG_ATP_TST_main*/
